local sceneEnvironment = require('demosceneEnvironment')
scene = {} --     

function generateFlightTrajectory(model, speed, targetOffset)
	sceneAPI:addFlightController(model)
	sceneAPI:setUpdateFunc('mainThemeSceneUpdate')
	local ctrl = model.controller
	ctrl:setSpeed(speed) -- /
	ctrl:setTargetOffset(targetOffset) --    ,    	
	local ang=0
	local radius=0
	for i=0, 9, 1 do
		ang = (i/10)*6.2832 --2pi
		radius = 23000*(1+math.random(-40, 40)/100)
		ctrl:addKnot(math.sin(ang)*radius, 1500 + math.random(-1000, 1000), math.cos(ang)*radius);
	end
	local x,y,z = ctrl:getKnot(0)
	ctrl:addKnot(x,y,z);
end

function loadScene(scenePtr)
	sceneAPI = sceneEnvironment.getInterface(scenePtr)
	
	-- sceneAPI:setCloudsLowHigh(0, 2000)
	sceneAPI:setCloudsDensity(0)
	sceneAPI:setCirrus(false)	
	sceneAPI:setLensEffects(false)
	
	scene.cam = sceneAPI:addCamera(0, 0, 0)	
	scene.cam:setFarClip(100)
	
	-- --Su-27
	scene.su27 = sceneAPI:addModel("su-27", 0, 0, 0)
	scene.su27.transform:scale(250,250,250)
	generateFlightTrajectory(scene.su27, 6000, 800)
	scene.cam:attachTo(scene.su27, "Pylon1")
	-- -- --external
	scene.cam.transform:move(.1,1.2,5.2)	
	-- -- --cockpit
	-- -- scene.cam.transform:move(9.7,1.60,7.32)	

	

	
end


function mainThemeSceneUpdate(t, dt)
end



